import logging
from paho.mqtt import client as mqtt_client
from configparser import ConfigParser
import mylog

# 创建解析器对象
config = ConfigParser()
config.read('config.ini')
mqtt_host = config.get('mqttserver', 'host')
mqtt_port = config.get('mqttserver', 'port')
mqtt_user = config.get('mqttserver', 'user')
mqtt_password = config.get('mqttserver', 'password')
mqtt_topic = config.get('mqttserver', 'topic')


def on_connect(client, userdata, flags, rc, properties=None):
    if rc == 0:
        logging.info("Connected to MQTT Broker!")
    else:
        logging.info(f"Failed to connect, return code {rc}")


def on_message(client, userdata, msg):
    logging.info(msg.topic + " " + str(msg.payload))


def conn_mqtt():
    client = mqtt_client.Client(callback_api_version=mqtt_client.CallbackAPIVersion.VERSION2)
    client.username_pw_set(mqtt_user, mqtt_password)
    client.on_connect = on_connect
    client.connect(mqtt_host, int(mqtt_port))
    return client


def publish(client, msg, topic=mqtt_topic):
    res = client.publish(topic, payload=msg, qos=1)
    if res[0] == 0:
        logging.info(f"send {msg} successful!")
    else:
        logging.info("Fail to send msg!" + str(res[0]))

# if __name__ == "__main__":
#     data = {"face":"true", "num":"1"}
#     msg = json.dumps(data)
#     client = conn_mqtt()
#     publish(client, msg)
#     client.loop_forever()
